import './bootstrap';

// Basic JavaScript functionality
document.addEventListener('DOMContentLoaded', function() {
    // Auto-hide alerts after 5 seconds
    const alerts = document.querySelectorAll('.alert');
    alerts.forEach(alert => {
        setTimeout(() => {
            alert.style.transition = 'opacity 0.5s';
            alert.style.opacity = '0';
            setTimeout(() => {
                alert.remove();
            }, 500);
        }, 5000);
    });

    // File input preview (optional enhancement)
    const fileInputs = document.querySelectorAll('input[type="file"]');
    fileInputs.forEach(input => {
        input.addEventListener('change', function(e) {
            const files = e.target.files;
            if (files.length > 0) {
                const fileList = document.createElement('div');
                fileList.className = 'file-list';
                fileList.style.marginTop = '0.5rem';
                fileList.style.color = '#6b7280';
                fileList.style.fontSize = '0.875rem';
                
                let fileNames = Array.from(files).map(file => file.name).join(', ');
                if (fileNames.length > 50) {
                    fileNames = fileNames.substring(0, 50) + '...';
                }
                fileList.textContent = `Selected: ${fileNames}`;
                
                // Remove existing file list if any
                const existing = e.target.parentElement.querySelector('.file-list');
                if (existing) {
                    existing.remove();
                }
                
                e.target.parentElement.appendChild(fileList);
            }
        });
    });
});

